/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui;

import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import noppes.npcs.client.gui.select.GuiSoundSelection;
import noppes.npcs.client.gui.util.GuiNpcButton;
import noppes.npcs.client.gui.util.GuiNpcButtonYesNo;
import noppes.npcs.client.gui.util.GuiNpcLabel;
import noppes.npcs.client.gui.util.GuiNpcTextField;
import noppes.npcs.client.gui.util.IGuiNpcButton;
import noppes.npcs.client.gui.util.IGuiNpcTextField;
import noppes.npcs.client.gui.util.ISubGuiListener;
import noppes.npcs.client.gui.util.ITextfieldListener;
import noppes.npcs.client.gui.util.SubGuiInterface;
import noppes.npcs.entity.data.DataRanged;
import noppes.npcs.entity.data.DataStats;

public class SubGuiNpcRangeProperties
extends SubGuiInterface
implements ITextfieldListener,
ISubGuiListener {
    private final DataRanged ranged;
    private GuiNpcTextField soundSelected;
    private final DataStats stats;
    private final String[] fireType = new String[]{"gui.no", "gui.whendistant", "gui.whenhidden"};

    public SubGuiNpcRangeProperties(DataStats st) {
        this.setBackground("menubg.png");
        this.xSize = 256;
        this.ySize = 216;
        this.closeOnEsc = true;
        this.soundSelected = null;
        this.stats = st;
        this.ranged = st.ranged;
    }

    @Override
    public void buttonEvent(IGuiNpcButton button) {
        switch (button.getID()) {
            case 7: {
                this.soundSelected = (GuiNpcTextField)this.getTextField(7);
                this.setSubGui(new GuiSoundSelection(this.soundSelected.func_146179_b()));
                break;
            }
            case 9: {
                this.ranged.setHasAimAnimation(((GuiNpcButtonYesNo)button).getBoolean());
                break;
            }
            case 10: {
                this.soundSelected = (GuiNpcTextField)this.getTextField(10);
                this.setSubGui(new GuiSoundSelection(this.soundSelected.func_146179_b()));
                break;
            }
            case 11: {
                this.soundSelected = (GuiNpcTextField)this.getTextField(11);
                this.setSubGui(new GuiSoundSelection(this.soundSelected.func_146179_b()));
                break;
            }
            case 13: {
                this.ranged.setFireType(button.getValue());
                TextComponentTranslation hover = new TextComponentTranslation("stats.hover.availability", new Object[0]);
                hover.func_150257_a((ITextComponent)new TextComponentTranslation("stats.hover.availability." + this.ranged.getFireType(), new Object[]{new TextComponentTranslation(this.fireType[this.ranged.getFireType()], new Object[0]).func_150254_d(), "" + this.ranged.getRange() / 2.0}));
                if (this.ranged.getFireType() != 0) {
                    hover.func_150257_a((ITextComponent)new TextComponentTranslation("stats.hover.availability.3", new Object[0]));
                }
                button.setHoverText(hover.func_150254_d(), new Object[0]);
                break;
            }
            case 66: {
                this.close();
            }
        }
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        int y = this.guiTop + 4;
        GuiNpcTextField textField = new GuiNpcTextField(1, this, this.field_146289_q, this.guiLeft + 80, y, 50, 18, this.ranged.getAccuracy() + "");
        textField.setMinMaxDefault(0L, 100L, 90L);
        textField.setHoverText("stats.hover.attack.accuracy", new Object[0]);
        this.addTextField(textField);
        this.addLabel(new GuiNpcLabel(1, "stats.accuracy", this.guiLeft + 5, y + 5));
        textField = new GuiNpcTextField(8, this, this.field_146289_q, this.guiLeft + 200, y, 50, 18, this.ranged.getShotCount() + "");
        textField.setMinMaxDefault(1L, 10L, 1L);
        textField.setHoverText("stats.hover.shot.count", new Object[0]);
        this.addTextField(textField);
        this.addLabel(new GuiNpcLabel(8, "stats.burstcount", this.guiLeft + 135, y + 5));
        textField = new GuiNpcTextField(2, this, this.field_146289_q, this.guiLeft + 80, y += 22, 50, 18, this.ranged.getRange() + "");
        this.addLabel(new GuiNpcLabel(2, "gui.range", this.guiLeft + 5, y + 5));
        textField.setMinMaxDoubleDefault(2.0, 64.0, this.ranged.getRange());
        textField.setHoverText("stats.hover.attack.distance", new Object[0]);
        this.addTextField(textField);
        textField = new GuiNpcTextField(9, this, this.field_146289_q, this.guiLeft + 200, y, 30, 20, this.ranged.getMeleeRange() + "");
        textField.setMinMaxDefault(0L, this.stats.aggroRange, 5L);
        textField.setHoverText("stats.hover.attack.range", new Object[0]);
        this.addTextField(textField);
        this.addLabel(new GuiNpcLabel(16, "stats.meleerange", this.guiLeft + 135, y + 5));
        int j = this.guiLeft + 80;
        textField = new GuiNpcTextField(3, this, this.field_146289_q, j, y += 22, 50, 18, this.ranged.getDelayMin() + "");
        textField.setMinMaxDefault(1L, 9999L, 20L);
        textField.setHoverText("stats.hover.attack.min.time", new Object[0]);
        this.addTextField(textField);
        this.addLabel(new GuiNpcLabel(3, "stats.mindelay", this.guiLeft + 5, y + 5));
        textField = new GuiNpcTextField(4, this, this.field_146289_q, this.guiLeft + 200, y, 50, 18, this.ranged.getDelayMax() + "");
        textField.setMinMaxDefault(1L, 9999L, 20L);
        textField.setHoverText("stats.hover.attack.max.time", new Object[0]);
        this.addTextField(textField);
        this.addLabel(new GuiNpcLabel(4, "stats.maxdelay", this.guiLeft + 135, y + 5));
        textField = new GuiNpcTextField(6, this, this.field_146289_q, this.guiLeft + 80, y += 22, 50, 18, this.ranged.getBurst() + "");
        textField.setMinMaxDefault(1L, 100L, 20L);
        textField.setHoverText("stats.hover.shot.amount", new Object[0]);
        this.addTextField(textField);
        this.addLabel(new GuiNpcLabel(6, "stats.shotcount", this.guiLeft + 5, y + 5));
        textField = new GuiNpcTextField(5, this, this.field_146289_q, this.guiLeft + 200, y, 50, 18, this.ranged.getBurstDelay() + "");
        textField.setMinMaxDefault(1L, 30L, 5L);
        textField.setHoverText("stats.hover.shot.speed", new Object[0]);
        this.addTextField(textField);
        this.addLabel(new GuiNpcLabel(5, "stats.burstspeed", this.guiLeft + 135, y + 5));
        textField = new GuiNpcTextField(7, this, this.field_146289_q, this.guiLeft + 80, y += 22, 100, 20, this.ranged.getSound(0));
        textField.setHoverText("stats.hover.sound.shot", new Object[0]);
        this.addTextField(textField);
        GuiNpcButton button = new GuiNpcButton(7, this.guiLeft + 187, y, 60, 20, "mco.template.button.select");
        button.setHoverText("hover.set", new Object[0]);
        this.addButton(button);
        this.addLabel(new GuiNpcLabel(7, "stats.firesound", this.guiLeft + 5, y + 5));
        textField = new GuiNpcTextField(11, this, this.field_146289_q, this.guiLeft + 80, y += 22, 100, 20, this.ranged.getSound(1));
        textField.setHoverText("stats.hover.sound.hurt", new Object[0]);
        this.addTextField(textField);
        button = new GuiNpcButton(11, this.guiLeft + 187, y, 60, 20, "mco.template.button.select");
        button.setHoverText("hover.set", new Object[0]);
        this.addButton(button);
        this.addLabel(new GuiNpcLabel(11, "stats.hittingsound", this.guiLeft + 5, y + 5));
        textField = new GuiNpcTextField(10, this, this.field_146289_q, this.guiLeft + 80, y += 22, 100, 20, this.ranged.getSound(2));
        textField.setHoverText("stats.hover.sound.live", new Object[0]);
        this.addTextField(textField);
        this.addButton(new GuiNpcButton(10, this.guiLeft + 187, y, 60, 20, "mco.template.button.select"));
        button.setHoverText("hover.set", new Object[0]);
        this.addButton(button);
        this.addLabel(new GuiNpcLabel(10, "stats.hitsound", this.guiLeft + 5, y + 5));
        button = new GuiNpcButtonYesNo(9, this.guiLeft + 100, y += 22, this.ranged.getHasAimAnimation());
        button.setHoverText("stats.hover.aim", new Object[0]);
        this.addButton(button);
        this.addLabel(new GuiNpcLabel(9, "stats.aimWhileShooting", this.guiLeft + 5, y + 5));
        button = new GuiNpcButton(13, this.guiLeft + 100, y += 22, 80, 20, this.fireType, this.ranged.getFireType());
        TextComponentTranslation hover = new TextComponentTranslation("stats.hover.availability", new Object[0]);
        hover.func_150257_a((ITextComponent)new TextComponentTranslation("stats.hover.availability." + this.ranged.getFireType(), new Object[]{new TextComponentTranslation(this.fireType[this.ranged.getFireType()], new Object[0]).func_150254_d(), "" + this.ranged.getRange() / 2.0}));
        if (this.ranged.getFireType() != 0) {
            hover.func_150257_a((ITextComponent)new TextComponentTranslation("stats.hover.availability.3", new Object[0]));
        }
        button.setHoverText(hover.func_150254_d(), new Object[0]);
        this.addButton(button);
        this.addLabel(new GuiNpcLabel(13, "stats.indirect", this.guiLeft + 5, y + 5));
        button = new GuiNpcButton(66, this.guiLeft + 190, this.guiTop + 190, 60, 20, "gui.done");
        button.setHoverText("hover.back", new Object[0]);
        this.addButton(button);
    }

    @Override
    public void subGuiClosed(SubGuiInterface subgui) {
        GuiSoundSelection gss = (GuiSoundSelection)subgui;
        if (gss.selectedResource != null) {
            this.soundSelected.func_146180_a(gss.selectedResource.toString());
            this.unFocused(this.soundSelected);
        }
    }

    @Override
    public void unFocused(IGuiNpcTextField textfield) {
        switch (textfield.getID()) {
            case 1: {
                this.ranged.setAccuracy(textfield.getInteger());
                break;
            }
            case 2: {
                this.ranged.setRange(textfield.getDouble());
                break;
            }
            case 3: {
                this.ranged.setDelay(textfield.getInteger(), this.ranged.getDelayMax());
                break;
            }
            case 4: {
                this.ranged.setDelay(this.ranged.getDelayMin(), textfield.getInteger());
                break;
            }
            case 5: {
                this.ranged.setBurstDelay(textfield.getInteger());
                break;
            }
            case 6: {
                this.ranged.setBurst(textfield.getInteger());
                break;
            }
            case 7: {
                this.ranged.setSound(0, textfield.getFullText());
                break;
            }
            case 8: {
                this.ranged.setShotCount(textfield.getInteger());
                break;
            }
            case 9: {
                this.ranged.setMeleeRange(textfield.getInteger());
                break;
            }
            case 10: {
                this.ranged.setSound(2, textfield.getFullText());
                break;
            }
            case 11: {
                this.ranged.setSound(1, textfield.getFullText());
            }
        }
        this.func_73866_w_();
    }
}

